<?php
class ModelExtensionSmsadvertHelper extends Model
{
    public function sendSMS($phone, $message)
    {   	 
    	$token = $this->model_setting_setting->getSettingValue('smsadvert_token');
        $owndevices = $this->model_setting_setting->getSettingValue('smsadvert_owndeviceschannel');
        $failover = $this->model_setting_setting->getSettingValue('smsadvert_owndevicesfailover');

     	if(!empty($token)){
	    	$smsadvert = new ModelExtensionSmsadvertSmsadvert($token);
	    	$phone = $this->sanitizePhone($phone);
	    	$response = $smsadvert->sendMessage($phone, $message, $owndevices, $failover);
	    	return $response;
    	}
    	return false;
    }
    
    public function sanitizePhone($phone) {
        $clean_phone = preg_replace('/[^0-9]/', '', $phone);
        $prefix = substr($clean_phone, 0, 2);
        if($prefix == '00') {
            return '+'.substr($clean_phone, 2);
        }
        if($prefix == '07') {
            return '+4'.$clean_phone;
        }
        if($prefix == '40') {
            return '+'.$clean_phone;
        }
        return '+'.$clean_phone;
    }
}