<?php
class ModelExtensionSmsadvertSmsadvert extends Model
{
    private static $baseUrl = 'https://www.smsadvert.io/api/sms/';
    private $token;
    
    public function __construct($token)
    {
        $this->token = $token;
    }

    public function sendMessage($phone, $shortTextMessage, $owndevices, $failover)
    {
        $data = array();
        $data['phone'] = $phone;
        $data['shortTextMessage'] = $shortTextMessage;
        $data['sendAsShort'] = true;
        if($owndevices) {
            $data['sendAsShort'] = false;
            if($failover) {
                $data['failover'] = "short";
            }
        }
        return $this->makeRequest($data);
    }
    
    private function makeRequest($fields = array())
    {
        $token = $this->token;

        $url = self::$baseUrl;

        $fieldsString = http_build_query($fields);

        $headers = array();
        $headers[] = "Authorization: ".$token;
        $headers[] = "Content-Type: application/json";

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($fields));

        $result = curl_exec($curl);
        $return = array();
        $return['response'] = json_decode($result, true);

        if ($return['response'] == false) {
            $return['response'] = $result;
        }

        $return['status'] = curl_getinfo($curl, CURLINFO_HTTP_CODE);

        curl_close($curl);

        return $return;
    }
}